package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * The type Address.
 */
@Value
public class Address {
    Long id;
    String firstLine;
    String postCode;
    String city;
    String state;
    String country;
    List<Occupation> occupations;

    /**
     * Instantiates a new Address.
     *
     * @param id          the id
     * @param firstLine   the first line
     * @param postCode    the post code
     * @param city        the city
     * @param state       the state
     * @param country     the country
     * @param occupations the occupations
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "firstLine",
            "postCode",
            "city",
            "state",
            "country",
            "occupations",
    })
    public Address(
            @JsonProperty("id") Long id,
            @JsonProperty("firstLine") String firstLine,
            @JsonProperty("postCode") String postCode,
            @JsonProperty("city") String city,
            @JsonProperty("state") String state,
            @JsonProperty("country") String country,
            @JsonProperty("occupations") List<Occupation> occupations
    ) {
        this.id = id;
        this.firstLine = firstLine;
        this.postCode = postCode;
        this.city = city;
        this.state = state;
        this.country = country;
        this.occupations = Objects.requireNonNullElse(occupations, Collections.emptyList());
    }

    /**
     * Of address.
     *
     * @param id        the id
     * @param firstLine the first line
     * @param postCode  the post code
     * @param city      the city
     * @param state     the state
     * @param country   the country
     * @return the address
     */
    public static Address of(
            Long id,
            String firstLine,
            String postCode,
            String city,
            String state,
            String country
    ) {
        return new Address(
                id,
                firstLine,
                postCode,
                city,
                state,
                country,
                null
        );

    }

    /**
     * Of address.
     *
     * @param firstLine the first line
     * @param postCode  the post code
     * @param city      the city
     * @param state     the state
     * @param country   the country
     * @return the address
     */
    public static Address of(
            String firstLine,
            String postCode,
            String city,
            String state,
            String country
    ) {
        return new Address(
                null,
                firstLine,
                postCode,
                city,
                state,
                country,
                null
        );
    }

    /**
     * Of address.
     *
     * @param id          the id
     * @param firstLine   the first line
     * @param postCode    the post code
     * @param city        the city
     * @param state       the state
     * @param country     the country
     * @param occupations the occupations
     * @return the address
     */
    public static Address of(
            Long id,
            String firstLine,
            String postCode,
            String city,
            String state,
            String country,
            List<Occupation> occupations
    ) {
        return new Address(
                id,
                firstLine,
                postCode,
                city,
                state,
                country,
                occupations
        );
    }

    /**
     * Of address.
     *
     * @param firstLine   the first line
     * @param postCode    the post code
     * @param city        the city
     * @param state       the state
     * @param country     the country
     * @param occupations the occupations
     * @return the address
     */
    public static Address of(
            String firstLine,
            String postCode,
            String city,
            String state,
            String country,
            List<Occupation> occupations
    ) {
        return new Address(
                null,
                firstLine,
                postCode,
                city,
                state,
                country,
                occupations
        );
    }
}
