package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import org.apache.commons.lang3.BooleanUtils;

import java.beans.ConstructorProperties;
import java.time.LocalDate;

/**
 * The type Customer.
 */
@Value
public class Customer {

    Long id;
    String firstName;
    String lastName;

    LocalDate dateOfBirth;
    String phoneNumber;
    String email;
    boolean transferWiseAccountLinked;

    Address address;

    /**
     * Instantiates a new Customer.
     *
     * @param id                        the id
     * @param firstName                 the first name
     * @param lastName                  the last name
     * @param dateOfBirth               the date of birth
     * @param phoneNumber               the phone number
     * @param email                     the email
     * @param transferWiseAccountLinked the transfer wise account linked
     * @param address                   the address
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "firstName",
            "lastName",
            "dateOfBirth",
            "phoneNumber",
            "email",
            "transferWiseAccountLinked",
            "address"
    })
    public Customer(
            @JsonProperty("id") Long id,
            @JsonProperty("firstName") String firstName,
            @JsonProperty("lastName") String lastName,
            @JsonProperty("dateOfBirth") @JsonFormat(pattern = "yyyy-MM-dd") LocalDate dateOfBirth,
            @JsonProperty("phoneNumber") String phoneNumber,
            @JsonProperty("email") String email,
            @JsonProperty("transferWiseAccountLinked") Boolean transferWiseAccountLinked,
            @JsonProperty("address") Address address
    ) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.dateOfBirth = dateOfBirth;
        this.phoneNumber = phoneNumber;
        this.email = email;
        this.transferWiseAccountLinked = BooleanUtils.isTrue(transferWiseAccountLinked);
        this.address = address;
    }

    /**
     * Of customer.
     *
     * @param firstName   the first name
     * @param lastName    the last name
     * @param dateOfBirth the date of birth
     * @param phoneNumber the phone number
     * @param email       the email
     * @param address     the address
     * @return the customer
     */
    public static Customer of(
            String firstName,
            String lastName,
            LocalDate dateOfBirth,
            String phoneNumber,
            String email,
            Address address
    ) {
        return new Customer(
                null,
                firstName,
                lastName,
                dateOfBirth,
                phoneNumber,
                email,
                null,
                address
        );

    }

    /**
     * Update transfer wise account linked customer.
     *
     * @param transferWiseAccountLinked the transfer wise account linked
     * @return the customer
     */
    public Customer updateTransferWiseAccountLinked(
            final boolean transferWiseAccountLinked
    ) {
        return new Customer(
                this.id,
                this.firstName,
                this.lastName,
                this.dateOfBirth,
                this.phoneNumber,
                this.email,transferWiseAccountLinked,
                this.address
        );
    }
}
