package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import lombok.Value;
import org.springframework.util.Assert;

import java.beans.ConstructorProperties;
import java.util.List;

/**
 * The type New address request.
 */
@Value
public class NewAddressRequest {

    @NotNull
    String firstLine;

    @NotNull
    String postCode;

    @NotNull
    String city;

    String state;

    @NotNull
    @Pattern(regexp = "/^A[^ABCHJKNPVY]|B[^CKPUX]|C[^BEJPQST]|D[EJKMOZ]|E[CEGHRST]" +
            "|F[IJKMOR]|G[^CJKOVXZ]|H[KMNRTU]|I[DEL-OQ-T]|J[EMOP]|K[EGHIMNPRWYZ]" +
            "|L[ABCIKR-VY]|M[^BIJ]|N[ACEFGILOPRUZ]|OM|P[AE-HK-NRSTWY]|QA|R[EOSUW]|S[^FPQUW]" +
            "|T[^ABEIPQSUXY]|U[AGMSYZ]|V[ACEGINU]|WF|WS|YE|YT|Z[AMW]$/ix",
            message = "Please enter a valid ISO 3166-1 alpha-2 code")
    String country;

    List<NewOccupationRequest> occupations;

    /**
     * Instantiates a new New address request.
     *
     * @param firstLine   the first line
     * @param postCode    the post code
     * @param city        the city
     * @param state       the state
     * @param country     the country
     * @param occupations the occupations
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "firstLine",
            "postCode",
            "city",
            "state",
            "country",
            "occupations"
    })
    public NewAddressRequest(
            @JsonProperty("firstLine") @NotNull final String firstLine,
            @JsonProperty("postCode") @NotNull final String postCode,
            @JsonProperty("city") @NotNull final String city,
            @JsonProperty("state") final String state,
            @JsonProperty("country") @NotNull @Pattern(regexp = "/^A[^ABCHJKNPVY]|B[^CKPUX]|C[^BEJPQST]|D[EJKMOZ]|E[CEGHRST]" +
                    "|F[IJKMOR]|G[^CJKOVXZ]|H[KMNRTU]|I[DEL-OQ-T]|J[EMOP]|K[EGHIMNPRWYZ]" +
                    "|L[ABCIKR-VY]|M[^BIJ]|N[ACEFGILOPRUZ]|OM|P[AE-HK-NRSTWY]|QA|R[EOSUW]|S[^FPQUW]" +
                    "|T[^ABEIPQSUXY]|U[AGMSYZ]|V[ACEGINU]|WF|WS|YE|YT|Z[AMW]$/ix",
                    message = "Please enter a valid ISO 3166-1 alpha-2 code") final String country,
            @JsonProperty("occupations") final List<NewOccupationRequest> occupations
    ) {
        Assert.hasText(firstLine, "firstLine is required");
        Assert.hasText(postCode, "postCode is required");
        Assert.hasText(city, "city is required");
        Assert.hasText(country, "country is required");

        this.firstLine = firstLine;
        this.postCode = postCode;
        this.city = city;
        this.state = state;
        this.country = country;
        this.occupations = occupations;
    }

}
