package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotNull;
import lombok.Value;
import org.springframework.util.Assert;

import java.beans.ConstructorProperties;
import java.time.LocalDate;

/**
 * The type New customer request.
 */
@Value
public class NewCustomerRequest {

    @NotNull
    String firstName;

    @NotNull
    String lastName;

    @NotNull
    @Email
    String email;

    @NotNull
    LocalDate dateOfBirth;

    @NotNull
    String phoneNumber;

    @NotNull
    NewAddressRequest address;

    /**
     * Instantiates a new New customer request.
     *
     * @param firstName   the first name
     * @param lastName    the last name
     * @param email       the email
     * @param dateOfBirth the date of birth
     * @param phoneNumber the phone number
     * @param address     the address
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "firstName",
            "lastName",
            "email",
            "dateOfBirth",
            "phoneNumber",
            "address"
    })
    public NewCustomerRequest(
            @JsonProperty("firstName") @NotNull final String firstName,
            @JsonProperty("lastName") @NotNull final String lastName,
            @JsonProperty("email") @NotNull @Email final String email,
            @JsonProperty("dateOfBirth") @NotNull @JsonFormat(pattern = "yyyy-MM-dd") final LocalDate dateOfBirth,
            @JsonProperty("phoneNumber") @NotNull String phoneNumber,
            @JsonProperty("address") @NotNull NewAddressRequest address
    ) {
        Assert.notNull(firstName, "firstName must not be null");
        Assert.notNull(lastName, "lastName must not be null");
        Assert.notNull(email, "email must not be null");
        Assert.notNull(dateOfBirth, "dateOfBirth must not be null");
        Assert.notNull(phoneNumber, "phoneNumber must not be null");
        Assert.notNull(address, "address must not be null");

        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.dateOfBirth = dateOfBirth;
        this.phoneNumber = phoneNumber;
        this.address = address;
    }
}
