package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type New occupation request.
 */
@Value
public class NewOccupationRequest {

    @NotNull
    String code;

    @NotNull
    String format;

    /**
     * Instantiates a new New occupation request.
     *
     * @param code   the code
     * @param format the format
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "code",
            "format"
    })
    public NewOccupationRequest(
            @JsonProperty("code") String code,
            @JsonProperty("format") String format
    ) {
        this.code = code;
        this.format = format;
    }
}
