package travel.wink.wise.partner.customer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Occupation.
 */
@Value
public class Occupation {

    String code;
    String format;

    /**
     * Instantiates a new Occupation.
     *
     * @param code   the code
     * @param format the format
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "code",
            "format"
    })
    public Occupation(
            @JsonProperty("code") String code,
            @JsonProperty("format") String format
    ) {
        this.code = code;
        this.format = format;
    }
}
