/*
 * Copyright (c) 2024 Wink.
 */

package travel.wink.wise.partner.exceptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.List;

/**
 * Created on: 9/16/24.
 *
 * @author Bjorn Harvold Responsibility:
 */
@Value
public class WiseDataException {
    String code;
    String error;
    String errorDescription;
    List<WiseDataExceptionError> errors;

    /**
     * Instantiates a new Wise data exception.
     *
     * @param code             the code
     * @param error            the error
     * @param errorDescription the error description
     * @param errors           the errors
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "code",
            "error",
            "errorDescription",
            "errors"
    })
    public WiseDataException(
            @JsonProperty("code") String code,
            @JsonProperty("error") String error,
            @JsonProperty("error_description") String errorDescription,
            @JsonProperty("errors") List<WiseDataExceptionError> errors
    ) {
        this.code = code;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errors = errors;
    }
}
