/*
 * Copyright (c) 2024 Wink.
 */

package travel.wink.wise.partner.exceptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.List;

/**
 * Created on: 9/16/24.
 *
 * @author Bjorn Harvold Responsibility:
 */
@Value
public class WiseDataExceptionError {
    String error;
    String errorDescription;

    Instant timestamp;
    String code;
    String path;
    String message;
    List<String> arguments;
    String status;

    /**
     * Instantiates a new Wise data exception error.
     *
     * @param error            the error
     * @param errorDescription the error description
     * @param timestamp        the timestamp
     * @param code             the code
     * @param path             the path
     * @param message          the message
     * @param arguments        the arguments
     * @param status           the status
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "error",
            "errorDescription",
            "timestamp",
            "code",
            "path",
            "message",
            "arguments",
            "status"
    })
    public WiseDataExceptionError(
            @JsonProperty("error") String error,
            @JsonProperty("error_description") String errorDescription,
            @JsonProperty("timestamp") Instant timestamp,
            @JsonProperty("code") String code,
            @JsonProperty("path") String path,
            @JsonProperty("message") String message,
            @JsonProperty("arguments") List<String> arguments,
            @JsonProperty("status") String status
    ) {
        this.error = error;
        this.errorDescription = errorDescription;
        this.timestamp = timestamp;
        this.code = code;
        this.path = path;
        this.message = message;
        this.arguments = arguments;
        this.status = status;
    }
}
