/*
 * Copyright (c) 2024 Wink.
 */

package travel.wink.wise.partner.exceptions;

import java.util.List;

/**
 * Created on: 1/18/22.
 *
 * @author Bjorn Harvold Responsibility:
 */
public class WiseException extends RuntimeException {
    /**
     * The Error.
     */
    String error;
    /**
     * The Error description.
     */
    String errorDescription;
    /**
     * The Errors.
     */
    List<WiseDataExceptionError> errors;

    /**
     * Instantiates a new Wise exception.
     *
     * @param error            the error
     * @param errorDescription the error description
     * @param errors           the errors
     */
    public WiseException(
            String error,
            String errorDescription,
            List<WiseDataExceptionError> errors
    ) {
        this.error = error;
        this.errorDescription = errorDescription;
        this.errors = errors;
    }

    /**
     * Instantiates a new Wise exception.
     *
     * @param message          the message
     * @param error            the error
     * @param errorDescription the error description
     * @param errors           the errors
     */
    public WiseException(
            String message,
            String error,
            String errorDescription,
            List<WiseDataExceptionError> errors
    ) {
        super(message);
        this.error = error;
        this.errorDescription = errorDescription;
        this.errors = errors;
    }

    /**
     * Instantiates a new Wise exception.
     *
     * @param message          the message
     * @param cause            the cause
     * @param error            the error
     * @param errorDescription the error description
     * @param errors           the errors
     */
    public WiseException(
            String message,
            Throwable cause,
            String error,
            String errorDescription,
            List<WiseDataExceptionError> errors
    ) {
        super(message, cause);
        this.error = error;
        this.errorDescription = errorDescription;
        this.errors = errors;
    }

    /**
     * Instantiates a new Wise exception.
     *
     * @param cause            the cause
     * @param error            the error
     * @param errorDescription the error description
     * @param errors           the errors
     */
    public WiseException(
            Throwable cause,
            String error,
            String errorDescription,
            List<WiseDataExceptionError> errors
    ) {
        super(cause);
        this.error = error;
        this.errorDescription = errorDescription;
        this.errors = errors;
    }

    /**
     * Instantiates a new Wise exception.
     *
     * @param message            the message
     * @param cause              the cause
     * @param enableSuppression  the enable suppression
     * @param writableStackTrace the writable stack trace
     * @param error              the error
     * @param errorDescription   the error description
     * @param errors             the errors
     */
    public WiseException(
            String message,
            Throwable cause,
            boolean enableSuppression,
            boolean writableStackTrace,
            String error,
            String errorDescription,
            List<WiseDataExceptionError> errors
    ) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.error = error;
        this.errorDescription = errorDescription;
        this.errors = errors;
    }

    /**
     * Of wise exception.
     *
     * @param ex the ex
     * @return the wise exception
     */
    public static WiseException of(WiseDataException ex) {
        return new WiseException(
                ex.getError(),
                ex.getErrorDescription(),
                ex.getErrors()
        );
    }
}
