/*
 * Copyright (c) 2024 Wink.
 */

package travel.wink.wise.partner.exceptions;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;
import java.io.Serializable;

/**
 * Created on: 1/18/22.
 *
 * @author Bjorn Harvold Responsibility:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WiseFaultException extends RuntimeException implements Serializable {
    @Serial
    private static final long serialVersionUID = 6054671970459291628L;

    private final String body;
    private final int statusCode;

    /**
     * Instantiates a new Payment fault exception.
     *
     * @param body          the body
     * @param rawStatusCode the raw status code
     */
    public WiseFaultException(String body, int rawStatusCode) {
        this.body = body;
        this.statusCode = rawStatusCode;
    }
}
