package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;

/**
 * The type Create anonymous quote.
 */
@Value
public class CreateAnonymousQuote {

    String sourceCurrency;
    String targetCurrency;
    BigDecimal sourceAmount;
    BigDecimal targetAmount;

    /**
     * Instantiates a new Create anonymous quote.
     *
     * @param sourceCurrency the source currency
     * @param targetCurrency the target currency
     * @param sourceAmount   the source amount
     * @param targetAmount   the target amount
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "sourceCurrency",
            "targetCurrency",
            "sourceAmount",
            "targetAmount"
    })
    public CreateAnonymousQuote(
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("sourceAmount") BigDecimal sourceAmount,
            @JsonProperty("targetAmount") BigDecimal targetAmount
    ) {
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
    }
}
