package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;

/**
 * The type Create quote.
 */
@Value
public class CreateQuote {

    Long profile;
    String sourceCurrency;
    String targetCurrency;
    BigDecimal sourceAmount;
    BigDecimal targetAmount;

    /**
     * Instantiates a new Create quote.
     *
     * @param profile        the profile
     * @param sourceCurrency the source currency
     * @param targetCurrency the target currency
     * @param sourceAmount   the source amount
     * @param targetAmount   the target amount
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "profile",
            "sourceCurrency",
            "targetCurrency",
            "sourceAmount",
            "targetAmount"
    })
    public CreateQuote(
            @JsonProperty("profile") Long profile,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("sourceAmount") BigDecimal sourceAmount,
            @JsonProperty("targetAmount") BigDecimal targetAmount
    ) {
        this.profile = profile;
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
    }

    /**
     * Update profile create quote.
     *
     * @param profile the profile
     * @return the create quote
     */
    public CreateQuote updateProfile(final Long profile) {
        return new CreateQuote(
                profile,
                this.sourceCurrency,
                this.targetCurrency,
                this.sourceAmount,
                this.targetAmount
        );
    }
}
