package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Disabled reason.
 */
@Value
public class DisabledReason {
    String code;
    String message;

    /**
     * Instantiates a new Disabled reason.
     *
     * @param code    the code
     * @param message the message
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "code",
            "message"
    })
    public DisabledReason(
            @JsonProperty("code") String code,
            @JsonProperty("message") String message
    ) {
        this.code = code;
        this.message = message;
    }
}
