package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;

/**
 * The type Fee.
 */
@Value
public class Fee {

    BigDecimal transferwise;
    BigDecimal payIn;
    BigDecimal discount;
    BigDecimal total;

    /**
     * Instantiates a new Fee.
     *
     * @param transferwise the transferwise
     * @param payIn        the pay in
     * @param discount     the discount
     * @param total        the total
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "transferwise",
            "payIn",
            "discount",
            "total"
    })
    public Fee(
            @JsonProperty("transferwise") BigDecimal transferwise,
            @JsonProperty("payIn") BigDecimal payIn,
            @JsonProperty("discount") BigDecimal discount,
            @JsonProperty("total") BigDecimal total
    ) {
        this.transferwise = transferwise;
        this.payIn = payIn;
        this.discount = discount;
        this.total = total;
    }
}
