package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Quote notice.
 */
@Value
public class QuoteNotice {

    String text;
    String link;
    String type;

    /**
     * Instantiates a new Quote notice.
     *
     * @param text the text
     * @param link the link
     * @param type the type
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "text",
            "link",
            "type"
    })
    public QuoteNotice(
            @JsonProperty("text") String text,
            @JsonProperty("link") String link,
            @JsonProperty("type") String type
    ) {
        this.text = text;
        this.link = link;
        this.type = type;
    }

}
