package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;

import static java.util.Objects.nonNull;

/**
 * The type Quote request.
 */
@Value
public class QuoteRequest {

    @NotNull
    String sourceCurrency;
    @NotNull
    String targetCurrency;
    BigDecimal sourceAmount;
    BigDecimal targetAmount;

    /**
     * Instantiates a new Quote request.
     *
     * @param sourceCurrency the source currency
     * @param targetCurrency the target currency
     * @param sourceAmount   the source amount
     * @param targetAmount   the target amount
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "sourceCurrency",
            "targetCurrency",
            "sourceAmount",
            "targetAmount"
    })
    public QuoteRequest(
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("sourceAmount") BigDecimal sourceAmount,
            @JsonProperty("targetAmount") BigDecimal targetAmount
    ) {
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
    }

    /**
     * Is amount present boolean.
     *
     * @return the boolean
     */
    boolean isAmountPresent() {
        return nonNull(this.sourceAmount) || nonNull(this.targetAmount);
    }
}
