package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

/**
 * The type Quote response.
 */
@Value
public class QuoteResponse {

    UUID id;
    String sourceCurrency;
    String targetCurrency;
    BigDecimal sourceAmount;
    BigDecimal targetAmount;
    BigDecimal rate;
    BigDecimal fee;
    String formattedEstimatedDelivery;
    String rateType;
    List<QuoteNotice> notices;

    /**
     * Instantiates a new Quote response.
     *
     * @param id                         the id
     * @param sourceCurrency             the source currency
     * @param targetCurrency             the target currency
     * @param sourceAmount               the source amount
     * @param targetAmount               the target amount
     * @param rate                       the rate
     * @param fee                        the fee
     * @param formattedEstimatedDelivery the formatted estimated delivery
     * @param rateType                   the rate type
     * @param notices                    the notices
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "sourceCurrency",
            "targetCurrency",
            "sourceAmount",
            "targetAmount",
            "rate",
            "fee",
            "formattedEstimatedDelivery",
            "rateType",
            "notices"
    })
    public QuoteResponse(
            @JsonProperty("id") UUID id,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("sourceAmount") BigDecimal sourceAmount,
            @JsonProperty("targetAmount") BigDecimal targetAmount,
            @JsonProperty("rate") BigDecimal rate,
            @JsonProperty("fee") BigDecimal fee,
            @JsonProperty("formattedEstimatedDelivery") String formattedEstimatedDelivery,
            @JsonProperty("rateType") String rateType,
            @JsonProperty("notices") List<QuoteNotice> notices
    ) {
        this.id = id;
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
        this.rate = rate;
        this.fee = fee;
        this.formattedEstimatedDelivery = formattedEstimatedDelivery;
        this.rateType = rateType;
        this.notices = notices;
    }

}
