package travel.wink.wise.partner.quote.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

/**
 * The type Wise quote response.
 */
@Value
public class WiseQuoteResponse {

    UUID id;
    String sourceCurrency;
    String targetCurrency;
    BigDecimal sourceAmount;
    BigDecimal targetAmount;
    String payOut;
    BigDecimal rate;

    LocalDateTime createdTime;
    BigDecimal fee;
    Integer user;
    Integer profile;
    String rateType;

    LocalDateTime rateExpirationTime;
    String providedAmountType;
    String status;

    LocalDateTime expirationTime;

    List<QuoteNotice> notices;
    List<PaymentOption> paymentOptions;

    /**
     * Instantiates a new Wise quote response.
     *
     * @param id                 the id
     * @param sourceCurrency     the source currency
     * @param targetCurrency     the target currency
     * @param sourceAmount       the source amount
     * @param targetAmount       the target amount
     * @param payOut             the pay out
     * @param rate               the rate
     * @param createdTime        the created time
     * @param fee                the fee
     * @param user               the user
     * @param profile            the profile
     * @param rateType           the rate type
     * @param rateExpirationTime the rate expiration time
     * @param providedAmountType the provided amount type
     * @param status             the status
     * @param expirationTime     the expiration time
     * @param notices            the notices
     * @param paymentOptions     the payment options
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "sourceCurrency",
            "targetCurrency",
            "sourceAmount",
            "targetAmount",
            "payOut",
            "rate",
            "createdTime",
            "fee",
            "user",
            "profile",
            "rateType",
            "rateExpirationTime",
            "providedAmountType",
            "impl",
            "expirationTime",
            "notices",
            "paymentOptions"
    })
    public WiseQuoteResponse(
            @JsonProperty("id") UUID id,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("sourceAmount") BigDecimal sourceAmount,
            @JsonProperty("targetAmount") BigDecimal targetAmount,
            @JsonProperty("payOut") String payOut,
            @JsonProperty("rate") BigDecimal rate,
            @JsonProperty("createdTime") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'") LocalDateTime createdTime,
            @JsonProperty("fee") BigDecimal fee,
            @JsonProperty("user") Integer user,
            @JsonProperty("profile") Integer profile,
            @JsonProperty("rateType") String rateType,
            @JsonProperty("rateExpirationTime") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'") LocalDateTime rateExpirationTime,
            @JsonProperty("providedAmountType") String providedAmountType,
            @JsonProperty("impl") String status,
            @JsonProperty("expirationTime") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss'Z'") LocalDateTime expirationTime,
            @JsonProperty("notices") List<QuoteNotice> notices,
            @JsonProperty("paymentOptions") List<PaymentOption> paymentOptions
    ) {
        this.id = id;
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
        this.payOut = payOut;
        this.rate = rate;
        this.createdTime = createdTime;
        this.fee = fee;
        this.user = user;
        this.profile = profile;
        this.rateType = rateType;
        this.rateExpirationTime = rateExpirationTime;
        this.providedAmountType = providedAmountType;
        this.status = status;
        this.expirationTime = expirationTime;
        this.notices = notices;
        this.paymentOptions = paymentOptions;
    }

    /**
     * Of wise quote response.
     *
     * @param paymentOptions the payment options
     * @return the wise quote response
     */
    public static WiseQuoteResponse of(final List<PaymentOption> paymentOptions) {
        return new WiseQuoteResponse(
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                null,
                paymentOptions
        );
    }

}
