package travel.wink.wise.partner.quote.client;

import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.quote.api.CreateAnonymousQuote;
import travel.wink.wise.partner.quote.api.CreateQuote;
import travel.wink.wise.partner.quote.api.Quote;

import java.util.UUID;

/**
 * The interface Wise quote client.
 */
public interface WiseQuoteClient {

    /**
     * Create anonymous quote mono.
     *
     * @param createAnonymousQuote the create anonymous quote
     * @return the mono
     */
    Mono<Quote> createAnonymousQuote(CreateAnonymousQuote createAnonymousQuote);

    /**
     * Create quote mono.
     *
     * @param twUserTokens the tw user tokens
     * @param createQuote  the create quote
     * @return the mono
     */
    Mono<Quote> createQuote(WiseUserTokens twUserTokens, CreateQuote createQuote);

    /**
     * Update quote mono.
     *
     * @param twUserTokens the tw user tokens
     * @param quoteId      the quote id
     * @param profileId    the profile id
     * @param recipientId  the recipient id
     * @return the mono
     */
    Mono<Quote> updateQuote(WiseUserTokens twUserTokens, UUID quoteId, Long profileId, Long recipientId);

    /**
     * Gets quote.
     *
     * @param twUserTokens the tw user tokens
     * @param quoteId      the quote id
     * @return the quote
     */
    Mono<Quote> getQuote(WiseUserTokens twUserTokens, UUID quoteId);
}
