package travel.wink.wise.partner.recipient.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import org.apache.commons.lang3.BooleanUtils;

import java.beans.ConstructorProperties;

/**
 * The type Recipient.
 */
@Value
public class Recipient {

    Long id;
    String currency;
    boolean active;
    boolean ownedByCustomer;
    String type;
    String accountSummary;
    Name name;

    /**
     * Instantiates a new Recipient.
     *
     * @param id              the id
     * @param currency        the currency
     * @param active          the active
     * @param ownedByCustomer the owned by customer
     * @param type            the type
     * @param accountSummary  the account summary
     * @param name            the name
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "currency",
            "active",
            "ownedByCustomer",
            "type",
            "accountSummary",
            "name"
    })
    public Recipient(
            @JsonProperty("id") Long id,
            @JsonProperty("currency") String currency,
            @JsonProperty("active") Boolean active,
            @JsonProperty("ownedByCustomer") Boolean ownedByCustomer,
            @JsonProperty("type") String type,
            @JsonProperty("accountSummary") String accountSummary,
            @JsonProperty("name") Name name
    ) {
        this.id = id;
        this.currency = currency;
        this.active = BooleanUtils.isTrue(active);
        this.ownedByCustomer = BooleanUtils.isTrue(ownedByCustomer);
        this.type = type;
        this.accountSummary = accountSummary;
        this.name = name;
    }
}
