package travel.wink.wise.partner.recipient.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.List;

/**
 * The type Wise recipients content.
 */
@Value
public class WiseRecipientsContent {

    List<Recipient> recipients;

    /**
     * Instantiates a new Wise recipients content.
     *
     * @param recipients the recipients
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "recipients"
    })
    public WiseRecipientsContent(
            @JsonProperty("content") List<Recipient> recipients
    ) {
        this.recipients = recipients;
    }
}
