package travel.wink.wise.partner.recipient.client;

import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.recipient.api.Recipient;

import java.util.UUID;

/**
 * The interface Wise recipient client.
 */
public interface WiseRecipientClient {

    /**
     * Gets recipient.
     *
     * @param twUserTokens the tw user tokens
     * @param recipientId  the recipient id
     * @return the recipient
     */
    Mono<Recipient> getRecipient(WiseUserTokens twUserTokens, Long recipientId);

    /**
     * Gets all recipients.
     *
     * @param twUserTokens the tw user tokens
     * @param twProfileId  the tw profile id
     * @param currencyCode the currency code
     * @return the all recipients
     */
    Flux<Recipient> getAllRecipients(WiseUserTokens twUserTokens, Long twProfileId, String currencyCode);

    /**
     * Create mono.
     *
     * @param twUserTokens the tw user tokens
     * @param requestBody  the request body
     * @return the mono
     */
    Mono<String> create(WiseUserTokens twUserTokens, String requestBody);

    /**
     * Gets requirements.
     *
     * @param twUserTokens the tw user tokens
     * @param quoteId      the quote id
     * @return the requirements
     */
    Mono<String> getRequirements(WiseUserTokens twUserTokens, UUID quoteId);

    /**
     * Create requirements mono.
     *
     * @param twUserTokens the tw user tokens
     * @param quoteId      the quote id
     * @param requestBody  the request body
     * @return the mono
     */
    Mono<String> createRequirements(WiseUserTokens twUserTokens, UUID quoteId, String requestBody);
}
