package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.UUID;

/**
 * The type Create transfer request.
 */
@Value
public class CreateTransferRequest {
    Long recipientId;
    UUID quoteId;
    TransferRequestDetails details;

    /**
     * Instantiates a new Create transfer request.
     *
     * @param recipientId the recipient id
     * @param quoteId     the quote id
     * @param details     the details
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "recipientId",
            "quoteId",
            "details"
    })
    public CreateTransferRequest(
            @JsonProperty("recipientId") Long recipientId,
            @JsonProperty("quoteId") UUID quoteId,
            @JsonProperty("details") TransferRequestDetails details
    ) {
        this.recipientId = recipientId;
        this.quoteId = quoteId;
        this.details = details;
    }
}
