package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

/**
 * The type Create transfer response.
 */
@Value
public class CreateTransferResponse {

    Long id;
    Long recipientId;
    UUID quoteId;
    String reference;
    BigDecimal rate;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    LocalDateTime created;
    String sourceCurrency;
    BigDecimal sourceValue;
    String targetCurrency;
    BigDecimal targetValue;
    UUID customerTransactionId;

    /**
     * Instantiates a new Create transfer response.
     *
     * @param id                    the id
     * @param recipientId           the recipient id
     * @param quoteId               the quote id
     * @param reference             the reference
     * @param rate                  the rate
     * @param created               the created
     * @param sourceCurrency        the source currency
     * @param sourceValue           the source value
     * @param targetCurrency        the target currency
     * @param targetValue           the target value
     * @param customerTransactionId the customer transaction id
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "recipientId",
            "quoteId",
            "reference",
            "rate",
            "created",
            "sourceCurrency",
            "sourceValue",
            "targetCurrency",
            "targetValue",
            "customerTransactionId"
    })
    public CreateTransferResponse(
            @JsonProperty("id") Long id,
            @JsonProperty("recipientId") Long recipientId,
            @JsonProperty("quoteId") UUID quoteId,
            @JsonProperty("reference") String reference,
            @JsonProperty("rate") BigDecimal rate,
            @JsonProperty("created") LocalDateTime created,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("sourceValue") BigDecimal sourceValue,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("targetValue") BigDecimal targetValue,
            @JsonProperty("customerTransactionId") UUID customerTransactionId
    ) {
        this.id = id;
        this.recipientId = recipientId;
        this.quoteId = quoteId;
        this.reference = reference;
        this.rate = rate;
        this.created = created;
        this.sourceCurrency = sourceCurrency;
        this.sourceValue = sourceValue;
        this.targetCurrency = targetCurrency;
        this.targetValue = targetValue;
        this.customerTransactionId = customerTransactionId;
    }
}
