package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import org.apache.commons.collections4.CollectionUtils;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

import static java.util.Comparator.comparing;

/**
 * The type Customer transfer.
 */
@Value
public class CustomerTransfer {
    Long id;
    Long customerId;
    Long recipientId;
    UUID quoteId;
    String reference;
    BigDecimal rate;
    LocalDateTime created;
    String sourceCurrency;
    BigDecimal sourceValue;
    String targetCurrency;
    BigDecimal targetValue;
    UUID customerTransactionId;
    String recipientName;
    BigDecimal fee;
    String accountSummary;
    List<CustomerTransferStatus> transferStatuses;

    /**
     * Instantiates a new Customer transfer.
     *
     * @param id                    the id
     * @param customerId            the customer id
     * @param recipientId           the recipient id
     * @param quoteId               the quote id
     * @param reference             the reference
     * @param rate                  the rate
     * @param created               the created
     * @param sourceCurrency        the source currency
     * @param sourceValue           the source value
     * @param targetCurrency        the target currency
     * @param targetValue           the target value
     * @param customerTransactionId the customer transaction id
     * @param recipientName         the recipient name
     * @param fee                   the fee
     * @param accountSummary        the account summary
     * @param transferStatuses      the transfer statuses
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "customerId",
            "recipientId",
            "quoteId",
            "reference",
            "rate",
            "created",
            "sourceCurrency",
            "sourceValue",
            "targetCurrency",
            "targetValue",
            "customerTransactionId",
            "recipientName",
            "fee",
            "accountSummary",
            "transferStatuses"
    })
    public CustomerTransfer(
            @JsonProperty("id") Long id,
            @JsonProperty("customerId") Long customerId,
            @JsonProperty("recipientId") Long recipientId,
            @JsonProperty("quoteId") UUID quoteId,
            @JsonProperty("reference") String reference,
            @JsonProperty("rate") BigDecimal rate,
            @JsonProperty("created") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss") LocalDateTime created,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("sourceValue") BigDecimal sourceValue,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("targetValue") BigDecimal targetValue,
            @JsonProperty("customerTransactionId") UUID customerTransactionId,
            @JsonProperty("recipientName") String recipientName,
            @JsonProperty("fee") BigDecimal fee,
            @JsonProperty("accountSummary") String accountSummary,
            @JsonProperty("transferStatuses") List<CustomerTransferStatus> transferStatuses
    ) {
        this.id = id;
        this.customerId = customerId;
        this.recipientId = recipientId;
        this.quoteId = quoteId;
        this.reference = reference;
        this.rate = rate;
        this.created = created;
        this.sourceCurrency = sourceCurrency;
        this.sourceValue = sourceValue;
        this.targetCurrency = targetCurrency;
        this.targetValue = targetValue;
        this.customerTransactionId = customerTransactionId;
        this.recipientName = recipientName;
        this.fee = fee;
        this.accountSummary = accountSummary;
        this.transferStatuses = CollectionUtils.isNotEmpty(transferStatuses) ? transferStatuses.stream().sorted(comparing(CustomerTransferStatus::getEventTime)).toList() : Collections.emptyList();
    }
}
