package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;

/**
 * The type Customer transfer status.
 */
@Value
public class CustomerTransferStatus {

    Long customerTransferId;
    String newState;
    LocalDateTime eventTime;

    /**
     * Instantiates a new Customer transfer status.
     *
     * @param customerTransferId the customer transfer id
     * @param newState           the new state
     * @param eventTime          the event time
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "customerTransferId",
            "newState",
            "eventTime"
    })
    public CustomerTransferStatus(
            @JsonProperty("customerTransferId") Long customerTransferId,
            @JsonProperty("newState") String newState,
            @JsonProperty("eventTime") LocalDateTime eventTime
    ) {
        this.customerTransferId = customerTransferId;
        this.newState = newState;
        this.eventTime = eventTime;
    }
}
