package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.List;

/**
 * The type Field.
 */
@Value
public class Field {

    String name;
    List<Group> group;

    /**
     * Instantiates a new Field.
     *
     * @param name  the name
     * @param group the group
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "name",
            "group",
    })
    public Field(String name, List<Group> group) {
        this.name = name;
        this.group = group;
    }

}
