package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Group.
 */
@Value
public class Group {
    String key;
    Integer minLength;
    Integer maxLength;
    String validationRegexp;

    /**
     * Instantiates a new Group.
     *
     * @param key              the key
     * @param minLength        the min length
     * @param maxLength        the max length
     * @param validationRegexp the validation regexp
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "key",
            "minLength",
            "maxLength",
            "validationRegexp"
    })
    public Group(
            @JsonProperty("key") String key,
            @JsonProperty("minLength") Integer minLength,
            @JsonProperty("maxLength") Integer maxLength,
            @JsonProperty("validationRegexp") String validationRegexp
    ) {
        this.key = key;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.validationRegexp = validationRegexp;
    }
}
