package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Transfer reference validation.
 */
@Value
public class TransferReferenceValidation {
    Integer minLength;
    Integer maxLength;
    String validationRegexp;

    /**
     * Instantiates a new Transfer reference validation.
     *
     * @param minLength        the min length
     * @param maxLength        the max length
     * @param validationRegexp the validation regexp
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "minLength",
            "maxLength",
            "validationRegexp"
    })
    public TransferReferenceValidation(
            @JsonProperty("minLength") Integer minLength,
            @JsonProperty("maxLength") Integer maxLength,
            @JsonProperty("validationRegexp") String validationRegexp
    ) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.validationRegexp = validationRegexp;
    }
}
