package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.UUID;

/**
 * The type Transfer request.
 */
@Value
public class TransferRequest {

    Long targetAccount;
    UUID quoteUuid;
    UUID customerTransactionId;
    TransferRequestDetails details;

    /**
     * Instantiates a new Transfer request.
     *
     * @param targetAccount         the target account
     * @param quoteUuid             the quote uuid
     * @param customerTransactionId the customer transaction id
     * @param details               the details
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "targetAccount",
            "quoteUuid",
            "customerTransactionId",
            "details"
    })
    public TransferRequest(
            @JsonProperty("targetAccount") Long targetAccount,
            @JsonProperty("quoteUuid") UUID quoteUuid,
            @JsonProperty("customerTransactionId") UUID customerTransactionId,
            @JsonProperty("details") TransferRequestDetails details
    ) {
        this.targetAccount = targetAccount;
        this.quoteUuid = quoteUuid;
        this.customerTransactionId = customerTransactionId;
        this.details = details;
    }

    /**
     * Of transfer request.
     *
     * @param targetAccount the target account
     * @param quoteUuid     the quote uuid
     * @return the transfer request
     */
    public static TransferRequest of(
            Long targetAccount,
            UUID quoteUuid
    ) {
        return new TransferRequest(
                targetAccount,
                quoteUuid,
                null,
                null
        );
    }

    /**
     * Update customer transaction id transfer request.
     *
     * @param customerTransactionId the customer transaction id
     * @return the transfer request
     */
    public TransferRequest updateCustomerTransactionId(
            final UUID customerTransactionId
    ) {
        return new TransferRequest(
                this.targetAccount,
                this.quoteUuid,
                customerTransactionId,
                this.details
        );
    }
}
