package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;

/**
 * The type Transfer request details.
 */
@Value
public class TransferRequestDetails {

    String reference;
    String transferPurpose;
    String sourceOfFunds;

    /**
     * Instantiates a new Transfer request details.
     *
     * @param reference       the reference
     * @param transferPurpose the transfer purpose
     * @param sourceOfFunds   the source of funds
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "reference",
            "transferPurpose",
            "sourceOfFunds"
    })
    public TransferRequestDetails(
            @JsonProperty("reference") String reference,
            @JsonProperty("transferPurpose") String transferPurpose,
            @JsonProperty("sourceOfFunds") String sourceOfFunds
    ) {
        this.reference = reference;
        this.transferPurpose = transferPurpose;
        this.sourceOfFunds = sourceOfFunds;
    }
}
