package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.util.List;

/**
 * The type Transfer requirement.
 */
@Value
public class TransferRequirement {

    String type;
    List<Field> fields;

    /**
     * Instantiates a new Transfer requirement.
     *
     * @param type   the type
     * @param fields the fields
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "type",
            "fields",
    })
    public TransferRequirement(
            @JsonProperty("type") String type,
            @JsonProperty("fields") List<Field> fields
    ) {
        this.type = type;
        this.fields = fields;
    }
}

