package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;

/**
 * The type Transfer status change data.
 */
@Value
class TransferStatusChangeData {

    TransferStatusChangeResource resource;

//    @JsonProperty("current_state")
    String currentState;

//    @JsonProperty("previous_state")
    String previousState;

//    @JsonProperty("occurred_at")
    ZonedDateTime occurredAt;

    /**
     * Instantiates a new Transfer status change data.
     *
     * @param resource      the resource
     * @param currentState  the current state
     * @param previousState the previous state
     * @param occurredAt    the occurred at
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "resource",
            "currentState",
            "previousState",
            "occurredAt"
    })
    public TransferStatusChangeData(
            @JsonProperty("resource") TransferStatusChangeResource resource,
            @JsonProperty("current_state") String currentState,
            @JsonProperty("previous_state") String previousState,
            @JsonProperty("occurred_at") ZonedDateTime occurredAt
    ) {
        this.resource = resource;
        this.currentState = currentState;
        this.previousState = previousState;
        this.occurredAt = occurredAt;
    }
}
