package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;

/**
 * The type Transfer status change event.
 */
@Value
public class TransferStatusChangeEvent {

    TransferStatusChangeData data;
    String subscriptionId;
    String eventType;
    String schemaVersion;
    ZonedDateTime sentAt;

    /**
     * Instantiates a new Transfer status change event.
     *
     * @param data           the data
     * @param subscriptionId the subscription id
     * @param eventType      the event type
     * @param schemaVersion  the schema version
     * @param sentAt         the sent at
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "data",
            "subscriptionId",
            "eventType",
            "schemaVersion",
            "sentAt"
    })
    public TransferStatusChangeEvent(
            @JsonProperty("") TransferStatusChangeData data,
            @JsonProperty("subscription_id") String subscriptionId,
            @JsonProperty("event_type") String eventType,
            @JsonProperty("schema_version") String schemaVersion,
            @JsonProperty("sent_at") ZonedDateTime sentAt
    ) {
        this.data = data;
        this.subscriptionId = subscriptionId;
        this.eventType = eventType;
        this.schemaVersion = schemaVersion;
        this.sentAt = sentAt;
    }

    /**
     * To customer transfer status customer transfer status.
     *
     * @return the customer transfer status
     */
    public CustomerTransferStatus toCustomerTransferStatus() {
        return new CustomerTransferStatus(
                this.getData().getResource().getId(),
                this.getData().getCurrentState(),
                this.getData().getOccurredAt().toLocalDateTime()
        );
    }
}
