package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

/**
 * The type Transfer status change resource.
 */
@Value
public class TransferStatusChangeResource {

    /**
     * The Type.
     */
    static final String TYPE = "transfer";

    Long id;
    Long profileId;
    Long accountId;

    /**
     * Instantiates a new Transfer status change resource.
     *
     * @param id        the id
     * @param profileId the profile id
     * @param accountId the account id
     */
    public TransferStatusChangeResource(
            @JsonProperty("id") Long id,
            @JsonProperty("profile_id") Long profileId,
            @JsonProperty("account_id") Long accountId
    ) {
        this.id = id;
        this.profileId = profileId;
        this.accountId = accountId;
    }
}
