package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.UUID;

/**
 * The type Transfer summary.
 */
@Value
public class TransferSummary {

    UUID quoteId;
    Long recipientId;
    String sourceCurrency;
    String targetCurrency;
    BigDecimal sourceAmount;
    BigDecimal targetAmount;
    BigDecimal rate;
    BigDecimal fee;
    String recipientName;
    String accountSummary;
    String formattedEstimatedDelivery;
    TransferReferenceValidation transferReferenceValidation;

    /**
     * Instantiates a new Transfer summary.
     *
     * @param quoteId                     the quote id
     * @param recipientId                 the recipient id
     * @param sourceCurrency              the source currency
     * @param targetCurrency              the target currency
     * @param sourceAmount                the source amount
     * @param targetAmount                the target amount
     * @param rate                        the rate
     * @param fee                         the fee
     * @param recipientName               the recipient name
     * @param accountSummary              the account summary
     * @param formattedEstimatedDelivery  the formatted estimated delivery
     * @param transferReferenceValidation the transfer reference validation
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "quoteId",
            "recipientId",
            "sourceCurrency",
            "targetCurrency",
            "sourceAmount",
            "targetAmount",
            "rate",
            "fee",
            "recipientName",
            "accountSummary",
            "formattedEstimatedDelivery",
            "transferReferenceValidation"
    })
    public TransferSummary(
            @JsonProperty("quoteId") UUID quoteId,
            @JsonProperty("recipientId") Long recipientId,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("sourceAmount") BigDecimal sourceAmount,
            @JsonProperty("targetAmount") BigDecimal targetAmount,
            @JsonProperty("rate") BigDecimal rate,
            @JsonProperty("fee") BigDecimal fee,
            @JsonProperty("recipientName") String recipientName,
            @JsonProperty("accountSummary") String accountSummary,
            @JsonProperty("formattedEstimatedDelivery") String formattedEstimatedDelivery,
            @JsonProperty("transferReferenceValidation") TransferReferenceValidation transferReferenceValidation
    ) {
        this.quoteId = quoteId;
        this.recipientId = recipientId;
        this.sourceCurrency = sourceCurrency;
        this.targetCurrency = targetCurrency;
        this.sourceAmount = sourceAmount;
        this.targetAmount = targetAmount;
        this.rate = rate;
        this.fee = fee;
        this.recipientName = recipientName;
        this.accountSummary = accountSummary;
        this.formattedEstimatedDelivery = formattedEstimatedDelivery;
        this.transferReferenceValidation = transferReferenceValidation;
    }
}
