package travel.wink.wise.partner.transfer.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;

/**
 * The type Transfer wise transfer.
 */
@Value
public class TransferWiseTransfer {

    Long id;
    Long targetAccount;
    UUID quoteUuid;
    String reference;
    BigDecimal rate;

    LocalDateTime created;
    String sourceCurrency;
    BigDecimal sourceValue;
    String targetCurrency;
    BigDecimal targetValue;
    UUID customerTransactionId;

    /**
     * Instantiates a new Transfer wise transfer.
     *
     * @param id                    the id
     * @param targetAccount         the target account
     * @param quoteUuid             the quote uuid
     * @param reference             the reference
     * @param rate                  the rate
     * @param created               the created
     * @param sourceCurrency        the source currency
     * @param sourceValue           the source value
     * @param targetCurrency        the target currency
     * @param targetValue           the target value
     * @param customerTransactionId the customer transaction id
     */
    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties({
            "id",
            "targetAccount",
            "quoteUuid",
            "reference",
            "rate",
            "created",
            "sourceCurrency",
            "sourceValue",
            "targetCurrency",
            "targetValue",
            "customerTransactionId"
    })
    public TransferWiseTransfer(
            @JsonProperty("id") Long id,
            @JsonProperty("targetAccount") Long targetAccount,
            @JsonProperty("quoteUuid") UUID quoteUuid,
            @JsonProperty("reference") String reference,
            @JsonProperty("rate") BigDecimal rate,
            @JsonProperty("created") @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss") LocalDateTime created,
            @JsonProperty("sourceCurrency") String sourceCurrency,
            @JsonProperty("sourceValue") BigDecimal sourceValue,
            @JsonProperty("targetCurrency") String targetCurrency,
            @JsonProperty("targetValue") BigDecimal targetValue,
            @JsonProperty("customerTransactionId") UUID customerTransactionId
    ) {
        this.id = id;
        this.targetAccount = targetAccount;
        this.quoteUuid = quoteUuid;
        this.reference = reference;
        this.rate = rate;
        this.created = created;
        this.sourceCurrency = sourceCurrency;
        this.sourceValue = sourceValue;
        this.targetCurrency = targetCurrency;
        this.targetValue = targetValue;
        this.customerTransactionId = customerTransactionId;
    }
}
