package travel.wink.wise.partner.transfer.client;

import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.transfer.api.TransferRequest;
import travel.wink.wise.partner.transfer.api.TransferWiseTransfer;

/**
 * The interface Wise transfer client.
 */
public interface WiseTransferClient {

    /**
     * Create transfer mono.
     *
     * @param twUserTokens    the tw user tokens
     * @param transferRequest the transfer request
     * @return the mono
     */
    Mono<TransferWiseTransfer> createTransfer(WiseUserTokens twUserTokens, TransferRequest transferRequest);

    /**
     * Requirements mono.
     *
     * @param twUserTokens    the tw user tokens
     * @param transferRequest the transfer request
     * @return the mono
     */
    Mono<String> requirements(WiseUserTokens twUserTokens, TransferRequest transferRequest);
}
