package travel.wink.wise.partner.transfer.client.impl;

import lombok.RequiredArgsConstructor;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.transfer.api.TransferRequest;
import travel.wink.wise.partner.transfer.api.TransferWiseTransfer;
import travel.wink.wise.partner.transfer.client.WiseTransferClient;

import static org.springframework.http.HttpHeaders.AUTHORIZATION;
import static org.springframework.http.MediaType.APPLICATION_JSON;
import static travel.wink.wise.partner.client.TransferWisePaths.TRANSFERS_PATH;
import static travel.wink.wise.partner.client.TransferWisePaths.TRANSFER_REQUIREMENTS_PATH;

/**
 * The type Wise transfer client.
 */
@RequiredArgsConstructor
public class WiseTransferClientImpl implements WiseTransferClient {
    private final WebClient client;

    @Override
    public Mono<TransferWiseTransfer> createTransfer(WiseUserTokens twUserTokens, TransferRequest transferRequest) {
        return this.client.post()
                .uri(TRANSFERS_PATH)
                .header(AUTHORIZATION, twUserTokens.bearer())
                .contentType(APPLICATION_JSON)
                .bodyValue(transferRequest)
                .retrieve()
                .bodyToMono(TransferWiseTransfer.class);
    }

    @Override
    public Mono<String> requirements(WiseUserTokens twUserTokens, TransferRequest transferRequest) {
        return this.client.post()
                .uri(TRANSFER_REQUIREMENTS_PATH)
                .header(AUTHORIZATION, twUserTokens.bearer())
                .contentType(APPLICATION_JSON)
                .bodyValue(transferRequest)
                .retrieve()
                .bodyToMono(String.class);
    }
}
