/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.server.ResponseStatusException;

public final class ApiError {
    private final LocalDateTime timestamp;
    private final HttpStatusCode status;
    private final String message;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"timestamp", "impl", "message"})
    public ApiError(@JsonProperty(value="timestamp") @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy hh:mm:ss") LocalDateTime timestamp, @JsonProperty(value="impl") HttpStatusCode status, @JsonProperty(value="message") String message) {
        this.timestamp = timestamp;
        this.status = status;
        this.message = message;
    }

    public static ApiError of(ResponseStatusException cause) {
        return new ApiError(LocalDateTime.now(), cause.getStatusCode(), cause.getReason());
    }

    public static ApiError of(WebClientResponseException cause) {
        return new ApiError(LocalDateTime.now(), cause.getStatusCode(), cause.getResponseBodyAsString());
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public HttpStatusCode getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiError)) {
            return false;
        }
        ApiError other = (ApiError)o;
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        HttpStatusCode this$status = this.getStatus();
        HttpStatusCode other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        HttpStatusCode $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String toString() {
        return "ApiError(timestamp=" + String.valueOf(this.getTimestamp()) + ", status=" + String.valueOf(this.getStatus()) + ", message=" + this.getMessage() + ")";
    }
}

