/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.client;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import travel.wink.wise.partner.client.params.ClientId;
import travel.wink.wise.partner.client.params.Code;
import travel.wink.wise.partner.client.params.Email;
import travel.wink.wise.partner.client.params.GrantTypeAuthorizationCode;
import travel.wink.wise.partner.client.params.GrantTypeRefreshToken;
import travel.wink.wise.partner.client.params.GrantTypeRegistrationCode;
import travel.wink.wise.partner.client.params.Parameter;
import travel.wink.wise.partner.client.params.ProfileId;
import travel.wink.wise.partner.client.params.RedirectUri;
import travel.wink.wise.partner.client.params.RefreshToken;
import travel.wink.wise.partner.client.params.RegistrationCode;
import travel.wink.wise.partner.client.params.TargetAccount;
import travel.wink.wise.partner.credentials.api.WiseUser;

public class BodyRequests {
    public static BodyInserters.MultipartInserter forRefreshToken(RefreshToken refreshToken) {
        return BodyInserters.fromMultipartData(BodyRequests.multiMap(new GrantTypeRefreshToken(), refreshToken));
    }

    public static BodyInserters.MultipartInserter forAuthorizationCode(String clientId, String redirectUri, String code) {
        return BodyInserters.fromMultipartData(BodyRequests.multiMap(new GrantTypeAuthorizationCode(), new ClientId(clientId), new Code(code), new RedirectUri(redirectUri)));
    }

    public static BodyInserters.MultipartInserter forUserCredentials(String clientId, WiseUser twUser) {
        return BodyInserters.fromMultipartData(BodyRequests.multiMap(new GrantTypeRegistrationCode(), new Email(twUser.getEmail()), new ClientId(clientId), new RegistrationCode(twUser.getRegistrationCode())));
    }

    public static BodyInserter<Map<String, String>, ReactiveHttpOutputMessage> forQuoteUpdate(ProfileId profileId, TargetAccount targetAccount) {
        return BodyInserters.fromValue(BodyRequests.map(profileId, targetAccount));
    }

    private static Map<String, String> map(Parameter ... parameters) {
        return Arrays.stream(parameters).collect(Collectors.toMap(Parameter::key, Parameter::value));
    }

    static MultiValueMap<String, String> multiMap(Parameter ... parameters) {
        LinkedMultiValueMap multiMap = new LinkedMultiValueMap();
        multiMap.setAll(BodyRequests.map(parameters));
        return multiMap;
    }
}

