/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.client;

import java.util.UUID;

public interface TransferWisePaths {
    public static final String OAUTH_TOKEN_PATH = "/oauth/token";
    public static final String PROFILES_PATH_V1 = "/v1/profiles";
    public static final String PROFILES_PATH_V2 = "/v2/profiles";
    public static final String RECIPIENTS_PATH_V1 = "/v1/accounts";
    public static final String RECIPIENTS_PATH_V2 = "/v2/accounts";
    public static final String QUOTES_PATH_V1 = "/v1/quotes";
    public static final String QUOTES_PATH_V2 = "/v2/quotes/";
    public static final String SIGNUP_PATH = "/v1/user/signup/registration_code";
    public static final String TRANSFER_REQUIREMENTS_PATH = "/v1/transfer-requirements";
    public static final String TRANSFERS_PATH = "/v1/transfers";
    public static final String ADDRESS_PATH = "/v1/addresses";
    public static final String CURRENCY_PATH = "/v1/currencies";

    public static String recipientRequirementsPath(UUID quoteId) {
        return "/v1/quotes/" + String.valueOf(quoteId) + "/account-requirements";
    }

    public static String recipientByIdPath(Long recipientId) {
        return "/v2/accounts/" + recipientId;
    }

    public static String quotesPathV2(UUID quoteId) {
        return QUOTES_PATH_V2 + String.valueOf(quoteId);
    }

    public static String getProfilePath(Long profileId) {
        return "/v1/profiles/" + profileId;
    }

    public static String updateWindowPath(Long profileId) {
        return "/v1/profiles/" + profileId + "/update-window";
    }

    public static String getAddressByIdPath(Long addressId) {
        return "/v1/addresses/" + addressId;
    }
}

