/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Arrays;
import java.util.function.Function;
import org.springframework.web.util.UriBuilder;
import travel.wink.wise.partner.client.BodyRequests;
import travel.wink.wise.partner.client.params.Parameter;

public final class UriWithParams
implements Function<UriBuilder, URI> {
    private final String uri;
    private final Parameter[] parameters;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"uri", "parameters"})
    public UriWithParams(String uri, Parameter ... parameters) {
        this.uri = uri;
        this.parameters = parameters;
    }

    @Override
    public URI apply(UriBuilder builder) {
        return builder.path(this.uri).queryParams(BodyRequests.multiMap(this.parameters)).build(new Object[0]);
    }

    public String getUri() {
        return this.uri;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UriWithParams)) {
            return false;
        }
        UriWithParams other = (UriWithParams)o;
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        return Arrays.deepEquals(this.getParameters(), other.getParameters());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParameters());
        return result;
    }

    public String toString() {
        return "UriWithParams(uri=" + this.getUri() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
    }
}

