/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.config.WiseConfigProperties;
import travel.wink.wise.partner.credentials.client.WiseAddressClient;
import travel.wink.wise.partner.credentials.client.WiseCredentialsClient;
import travel.wink.wise.partner.credentials.client.WiseProfileClient;
import travel.wink.wise.partner.credentials.client.impl.WiseAddressClientImpl;
import travel.wink.wise.partner.credentials.client.impl.WiseCredentialsClientImpl;
import travel.wink.wise.partner.credentials.client.impl.WiseProfileClientImpl;
import travel.wink.wise.partner.currency.client.WiseCurrencyClient;
import travel.wink.wise.partner.currency.client.impl.WiseCurrencyClientImpl;
import travel.wink.wise.partner.exceptions.WiseDataException;
import travel.wink.wise.partner.exceptions.WiseException;
import travel.wink.wise.partner.exceptions.WiseFaultException;
import travel.wink.wise.partner.quote.client.WiseQuoteClient;
import travel.wink.wise.partner.quote.client.impl.WiseQuoteClientImpl;
import travel.wink.wise.partner.recipient.client.WiseRecipientClient;
import travel.wink.wise.partner.recipient.client.impl.WiseRecipientClientImpl;
import travel.wink.wise.partner.transfer.client.WiseTransferClient;
import travel.wink.wise.partner.transfer.client.impl.WiseTransferClientImpl;

@Configuration
public class WiseConfig {
    private static final Logger log = LoggerFactory.getLogger(WiseConfig.class);
    private static final ObjectMapper MAPPER = Jackson2ObjectMapperBuilder.json().modules(new Module[]{new JavaTimeModule()}).build();
    private final WiseConfigProperties props;

    @Bean(value={"wiseAddressClient"})
    public WiseAddressClient wiseAddressClient() {
        return new WiseAddressClientImpl(this.webClient());
    }

    @Bean(value={"wiseCredentialsClient"})
    public WiseCredentialsClient wiseCredentialsClient() {
        return new WiseCredentialsClientImpl(this.webClient(), this.props);
    }

    @Bean(value={"wiseProfileClient"})
    public WiseProfileClient wiseProfileClient() {
        return new WiseProfileClientImpl(this.webClient());
    }

    @Bean(value={"wiseCurrencyClient"})
    public WiseCurrencyClient wiseCurrencyClient() {
        return new WiseCurrencyClientImpl(this.webClient());
    }

    @Bean(value={"wiseQuoteClient"})
    public WiseQuoteClient wiseQuoteClient() {
        return new WiseQuoteClientImpl(this.webClient());
    }

    @Bean(value={"wiseRecipientClient"})
    public WiseRecipientClient wiseRecipientClient() {
        return new WiseRecipientClientImpl(this.webClient());
    }

    @Bean(value={"wiseTransferClient"})
    public WiseTransferClient wiseTransferClient() {
        return new WiseTransferClientImpl(this.webClient());
    }

    @Bean(value={"wiseWebClient"})
    public WebClient webClient() {
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(clientDefaultCodecsConfigurer -> {
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(MAPPER, new MimeType[]{MediaType.APPLICATION_JSON}));
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(MAPPER, new MimeType[]{MediaType.APPLICATION_JSON}));
        }).build();
        return WebClient.builder().defaultHeader("Content-Type", new String[]{"application/json"}).exchangeStrategies(strategies).filters(exchangeFilterFunctions -> exchangeFilterFunctions.add(this.logError())).baseUrl(this.props.getBaseUrl()).build();
    }

    private ExchangeFilterFunction logError() {
        return ExchangeFilterFunction.ofResponseProcessor(response -> {
            if (response.statusCode().is4xxClientError() || response.statusCode().is5xxServerError()) {
                return response.bodyToMono(String.class).flatMap(body -> {
                    log.error("Exception encountered when communicating with Wise SDK: Body is:\n{}", body);
                    try {
                        WiseDataException data = (WiseDataException)MAPPER.readValue(body, WiseDataException.class);
                        return Mono.error((Throwable)WiseException.of(data));
                    }
                    catch (JsonProcessingException e) {
                        return Mono.error((Throwable)new WiseFaultException((String)body, response.statusCode().value()));
                    }
                });
            }
            return Mono.just((Object)response);
        });
    }

    public WiseConfig(WiseConfigProperties props) {
        this.props = props;
    }
}

