/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import java.beans.ConstructorProperties;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="wise")
public final class WiseConfigProperties {
    @NotBlank
    @URL
    private final String baseUrl;
    @NotBlank
    private final String clientId;
    @NotBlank
    private final String clientSecret;
    @NotBlank
    private final String redirectUri;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"baseUrl", "clientId", "clientSecret", "redirectUri"})
    public WiseConfigProperties(@JsonProperty(value="baseUrl", required=true) @NotBlank @URL String baseUrl, @JsonProperty(value="clientId", required=true) @NotBlank String clientId, @JsonProperty(value="clientSecret", required=true) @NotBlank String clientSecret, @JsonProperty(value="redirectUri", required=true) @NotBlank String redirectUri) {
        Assert.hasText((String)baseUrl, (String)"baseUrl must not be empty");
        Assert.hasText((String)clientId, (String)"clientId must not be empty");
        Assert.hasText((String)clientSecret, (String)"clientSecret must not be empty");
        Assert.hasText((String)redirectUri, (String)"redirectUri must not be empty");
        this.baseUrl = baseUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiseConfigProperties)) {
            return false;
        }
        WiseConfigProperties other = (WiseConfigProperties)o;
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        return !(this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        return result;
    }

    public String toString() {
        return "WiseConfigProperties(baseUrl=" + this.getBaseUrl() + ", clientId=" + this.getClientId() + ", clientSecret=" + this.getClientSecret() + ", redirectUri=" + this.getRedirectUri() + ")";
    }
}

