/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import travel.wink.wise.partner.credentials.api.WiseOccupation;
import travel.wink.wise.partner.customer.api.Address;

public final class WiseAddress {
    private final String firstLine;
    private final String postCode;
    private final String city;
    private final String country;
    private final String state;
    private final List<WiseOccupation> occupations;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"firstLine", "postCode", "city", "state", "country", "occupations"})
    public WiseAddress(@JsonProperty(value="firstLine") String firstLine, @JsonProperty(value="postCode") String postCode, @JsonProperty(value="city") String city, @JsonProperty(value="state") String state, @JsonProperty(value="country") String country, @JsonProperty(value="occupations") List<WiseOccupation> occupations) {
        this.firstLine = firstLine;
        this.postCode = postCode;
        this.city = city;
        this.state = state;
        this.country = country;
        this.occupations = Objects.requireNonNullElse(occupations, Collections.emptyList());
    }

    public static WiseAddress of(Address address) {
        List<WiseOccupation> occupations = CollectionUtils.isNotEmpty(address.getOccupations()) ? address.getOccupations().stream().map(WiseOccupation::of).toList() : Collections.emptyList();
        return new WiseAddress(address.getFirstLine(), address.getPostCode(), address.getCity(), address.getState(), address.getCountry(), occupations);
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getState() {
        return this.state;
    }

    public List<WiseOccupation> getOccupations() {
        return this.occupations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiseAddress)) {
            return false;
        }
        WiseAddress other = (WiseAddress)o;
        String this$firstLine = this.getFirstLine();
        String other$firstLine = other.getFirstLine();
        if (this$firstLine == null ? other$firstLine != null : !this$firstLine.equals(other$firstLine)) {
            return false;
        }
        String this$postCode = this.getPostCode();
        String other$postCode = other.getPostCode();
        if (this$postCode == null ? other$postCode != null : !this$postCode.equals(other$postCode)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        List<WiseOccupation> this$occupations = this.getOccupations();
        List<WiseOccupation> other$occupations = other.getOccupations();
        return !(this$occupations == null ? other$occupations != null : !((Object)this$occupations).equals(other$occupations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $firstLine = this.getFirstLine();
        result = result * 59 + ($firstLine == null ? 43 : $firstLine.hashCode());
        String $postCode = this.getPostCode();
        result = result * 59 + ($postCode == null ? 43 : $postCode.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        List<WiseOccupation> $occupations = this.getOccupations();
        result = result * 59 + ($occupations == null ? 43 : ((Object)$occupations).hashCode());
        return result;
    }

    public String toString() {
        return "WiseAddress(firstLine=" + this.getFirstLine() + ", postCode=" + this.getPostCode() + ", city=" + this.getCity() + ", country=" + this.getCountry() + ", state=" + this.getState() + ", occupations=" + String.valueOf(this.getOccupations()) + ")";
    }
}

