/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;

public final class WiseClientCredentials {
    private final String token;
    private final ZonedDateTime expiresIn;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"token", "expiresIn"})
    public WiseClientCredentials(@JsonProperty(value="access_token") String token, @JsonProperty(value="expires_in") Integer expiresIn) {
        this.token = token;
        this.expiresIn = ZonedDateTime.now().plusSeconds(expiresIn.intValue());
    }

    public String bearer() {
        return String.format("Bearer %s", this.token);
    }

    public String getToken() {
        return this.token;
    }

    public ZonedDateTime getExpiresIn() {
        return this.expiresIn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiseClientCredentials)) {
            return false;
        }
        WiseClientCredentials other = (WiseClientCredentials)o;
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        ZonedDateTime this$expiresIn = this.getExpiresIn();
        ZonedDateTime other$expiresIn = other.getExpiresIn();
        return !(this$expiresIn == null ? other$expiresIn != null : !((Object)this$expiresIn).equals(other$expiresIn));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        ZonedDateTime $expiresIn = this.getExpiresIn();
        result = result * 59 + ($expiresIn == null ? 43 : ((Object)$expiresIn).hashCode());
        return result;
    }

    public String toString() {
        return "WiseClientCredentials(token=" + this.getToken() + ", expiresIn=" + String.valueOf(this.getExpiresIn()) + ")";
    }
}

