/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import travel.wink.wise.partner.credentials.api.ProfileDetails;
import travel.wink.wise.partner.credentials.api.WiseProfileResponse;

public final class WiseProfile {
    private final Long twProfileId;
    private final Long customerId;
    private final String type;
    private final ProfileDetails profileDetails;
    private final LocalDateTime updatedAt;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"twProfileId", "customerId", "type", "profileDetails", "updatedAt"})
    public WiseProfile(@JsonProperty(value="twProfileId") Long twProfileId, @JsonProperty(value="customerId") Long customerId, @JsonProperty(value="type") String type, @JsonProperty(value="profileDetails") ProfileDetails profileDetails, @JsonProperty(value="updatedAt") LocalDateTime updatedAt) {
        this.twProfileId = twProfileId;
        this.customerId = customerId;
        this.type = type;
        this.profileDetails = profileDetails;
        this.updatedAt = updatedAt;
    }

    public static WiseProfile of(Long twProfileId, Long customerId, String type, ProfileDetails profileDetails) {
        return new WiseProfile(twProfileId, customerId, type, profileDetails, null);
    }

    public static WiseProfile of(Long twProfileId, Long customerId, String type, LocalDateTime updatedAt) {
        return new WiseProfile(twProfileId, customerId, type, null, updatedAt);
    }

    public static WiseProfile of(Long customerId, WiseProfileResponse response) {
        return new WiseProfile(response.getId(), customerId, response.getType(), response.getDetails() != null ? ProfileDetails.of(response.getDetails()) : null, null);
    }

    public WiseProfile updateUpdatedAt(LocalDateTime updatedAt) {
        return new WiseProfile(this.twProfileId, this.customerId, this.type, this.profileDetails, updatedAt);
    }

    public boolean needsYearlyUpdate() {
        return this.updatedAt == null || this.updatedAt.isBefore(LocalDateTime.now().minusYears(1L));
    }

    public Long getTwProfileId() {
        return this.twProfileId;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public String getType() {
        return this.type;
    }

    public ProfileDetails getProfileDetails() {
        return this.profileDetails;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiseProfile)) {
            return false;
        }
        WiseProfile other = (WiseProfile)o;
        Long this$twProfileId = this.getTwProfileId();
        Long other$twProfileId = other.getTwProfileId();
        if (this$twProfileId == null ? other$twProfileId != null : !((Object)this$twProfileId).equals(other$twProfileId)) {
            return false;
        }
        Long this$customerId = this.getCustomerId();
        Long other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ProfileDetails this$profileDetails = this.getProfileDetails();
        ProfileDetails other$profileDetails = other.getProfileDetails();
        if (this$profileDetails == null ? other$profileDetails != null : !((Object)this$profileDetails).equals(other$profileDetails)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $twProfileId = this.getTwProfileId();
        result = result * 59 + ($twProfileId == null ? 43 : ((Object)$twProfileId).hashCode());
        Long $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ProfileDetails $profileDetails = this.getProfileDetails();
        result = result * 59 + ($profileDetails == null ? 43 : ((Object)$profileDetails).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "WiseProfile(twProfileId=" + this.getTwProfileId() + ", customerId=" + this.getCustomerId() + ", type=" + this.getType() + ", profileDetails=" + String.valueOf(this.getProfileDetails()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }
}

