/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.credentials.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;

public final class WiseUserTokens {
    private final Long customerId;
    private final Long twUserId;
    private final String accessToken;
    private final String refreshToken;
    private final ZonedDateTime expiryTime;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    @ConstructorProperties(value={"customerId", "twUserId", "accessToken", "refreshToken", "expiryTime"})
    public WiseUserTokens(@JsonProperty(value="customerId") Long customerId, @JsonProperty(value="twUserId") Long twUserId, @JsonProperty(value="accessToken") String accessToken, @JsonProperty(value="refreshToken") String refreshToken, @JsonProperty(value="expiryTime") ZonedDateTime expiryTime) {
        this.customerId = customerId;
        this.twUserId = twUserId;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiryTime = expiryTime;
    }

    public String bearer() {
        return String.format("Bearer %s", this.accessToken);
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public Long getTwUserId() {
        return this.twUserId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public ZonedDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WiseUserTokens)) {
            return false;
        }
        WiseUserTokens other = (WiseUserTokens)o;
        Long this$customerId = this.getCustomerId();
        Long other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        Long this$twUserId = this.getTwUserId();
        Long other$twUserId = other.getTwUserId();
        if (this$twUserId == null ? other$twUserId != null : !((Object)this$twUserId).equals(other$twUserId)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$refreshToken = this.getRefreshToken();
        String other$refreshToken = other.getRefreshToken();
        if (this$refreshToken == null ? other$refreshToken != null : !this$refreshToken.equals(other$refreshToken)) {
            return false;
        }
        ZonedDateTime this$expiryTime = this.getExpiryTime();
        ZonedDateTime other$expiryTime = other.getExpiryTime();
        return !(this$expiryTime == null ? other$expiryTime != null : !((Object)this$expiryTime).equals(other$expiryTime));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        Long $twUserId = this.getTwUserId();
        result = result * 59 + ($twUserId == null ? 43 : ((Object)$twUserId).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $refreshToken = this.getRefreshToken();
        result = result * 59 + ($refreshToken == null ? 43 : $refreshToken.hashCode());
        ZonedDateTime $expiryTime = this.getExpiryTime();
        result = result * 59 + ($expiryTime == null ? 43 : ((Object)$expiryTime).hashCode());
        return result;
    }

    public String toString() {
        return "WiseUserTokens(customerId=" + this.getCustomerId() + ", twUserId=" + this.getTwUserId() + ", accessToken=" + this.getAccessToken() + ", refreshToken=" + this.getRefreshToken() + ", expiryTime=" + String.valueOf(this.getExpiryTime()) + ")";
    }
}

