/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.wise.partner.credentials.client.impl;

import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Base64;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import travel.wink.wise.partner.client.BodyRequests;
import travel.wink.wise.partner.client.params.RefreshToken;
import travel.wink.wise.partner.config.WiseConfigProperties;
import travel.wink.wise.partner.credentials.api.WiseClientCredentials;
import travel.wink.wise.partner.credentials.api.WiseSignUpRequest;
import travel.wink.wise.partner.credentials.api.WiseUser;
import travel.wink.wise.partner.credentials.api.WiseUserResponse;
import travel.wink.wise.partner.credentials.api.WiseUserTokens;
import travel.wink.wise.partner.credentials.api.WiseUserTokensResponse;
import travel.wink.wise.partner.credentials.client.WiseCredentialsClient;

public class WiseCredentialsClientImpl
implements WiseCredentialsClient {
    private static final String GRANT_TYPE_CLIENT_CREDENTIALS = "grant_type=client_credentials";
    private final WebClient client;
    private final WiseConfigProperties props;

    @Override
    public Mono<WiseUser> signUp(String email, String registrationCode) {
        return this.twClientCredentials().flatMap(twClientCredentials -> this.signUp(email, registrationCode, (WiseClientCredentials)twClientCredentials));
    }

    @Override
    public Mono<WiseUserTokens> getUserTokensForCode(String code, Long customerId) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/oauth/token", new Object[0])).header("Authorization", new String[]{this.basicAuth()})).body((BodyInserter)BodyRequests.forAuthorizationCode(this.props.getClientId(), this.props.getRedirectUri(), code)).retrieve().bodyToMono(WiseUserTokensResponse.class).map(twUserTokensResponse -> new WiseUserTokens(customerId, null, twUserTokensResponse.getAccessToken(), twUserTokensResponse.getRefreshToken(), ZonedDateTime.now().plusSeconds(twUserTokensResponse.getExpiresIn().intValue())));
    }

    @Override
    public Mono<WiseUserTokens> getUserTokens(WiseUser twUser) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/oauth/token", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).header("Authorization", new String[]{this.basicAuth()})).body((BodyInserter)BodyRequests.forUserCredentials(this.props.getClientId(), twUser)).retrieve().bodyToMono(WiseUserTokensResponse.class).map(twUserTokensResponse -> new WiseUserTokens(twUser.getCustomerId(), twUser.getTwUserId(), twUserTokensResponse.getAccessToken(), twUserTokensResponse.getRefreshToken(), ZonedDateTime.now().plusSeconds(twUserTokensResponse.getExpiresIn().intValue())));
    }

    @Override
    public Mono<WiseUserTokens> refresh(WiseUserTokens twUserTokens) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/oauth/token", new Object[0])).header("Authorization", new String[]{this.basicAuth()})).body((BodyInserter)BodyRequests.forRefreshToken(new RefreshToken(twUserTokens.getRefreshToken()))).retrieve().bodyToMono(WiseUserTokensResponse.class).map(twUserTokensResponse -> new WiseUserTokens(twUserTokens.getCustomerId(), twUserTokens.getTwUserId(), twUserTokensResponse.getAccessToken(), twUserTokensResponse.getRefreshToken(), ZonedDateTime.now().plusSeconds(twUserTokensResponse.getExpiresIn().intValue())));
    }

    private Mono<WiseClientCredentials> twClientCredentials() {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/oauth/token", new Object[0])).contentType(MediaType.APPLICATION_FORM_URLENCODED).header("Authorization", new String[]{this.basicAuth()})).bodyValue((Object)GRANT_TYPE_CLIENT_CREDENTIALS).retrieve().bodyToMono(WiseClientCredentials.class);
    }

    private Mono<WiseUser> signUp(String email, String registrationCode, WiseClientCredentials twClientCredentials) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.client.post().uri("/v1/user/signup/registration_code", new Object[0])).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{twClientCredentials.bearer()})).bodyValue((Object)new WiseSignUpRequest(email, registrationCode)).retrieve().bodyToMono(WiseUserResponse.class).map(twUserResponse -> WiseUser.of(twUserResponse.getId(), twUserResponse.getEmail(), twUserResponse.getActive()));
    }

    private String basicAuth() {
        return String.format("Basic %s", this.encodedCredentials());
    }

    private String encodedCredentials() {
        return Base64.getEncoder().encodeToString(this.credentials().getBytes(StandardCharsets.UTF_8));
    }

    private String credentials() {
        return this.props.getClientId() + ":" + this.props.getClientSecret();
    }

    public WiseCredentialsClientImpl(WebClient client, WiseConfigProperties props) {
        this.client = client;
        this.props = props;
    }
}

